(function () {
    'use strict';

    var btn = document.getElementById('enacast-test-connection');
    var result = document.getElementById('enacast-test-result');

    if (!btn || !result) return;

    btn.addEventListener('click', function () {
        btn.disabled = true;
        result.className = 'enacast-test-result loading';
        result.textContent = 'Testing...';

        var xhr = new XMLHttpRequest();
        xhr.open('POST', enacast_admin.ajax_url, true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

        xhr.onload = function () {
            btn.disabled = false;
            try {
                var resp = JSON.parse(xhr.responseText);
                if (resp.success) {
                    result.className = 'enacast-test-result success';
                    result.textContent = resp.data;
                } else {
                    result.className = 'enacast-test-result error';
                    result.textContent = resp.data || 'Connection failed';
                }
            } catch (e) {
                result.className = 'enacast-test-result error';
                result.textContent = 'Invalid response';
            }
        };

        xhr.onerror = function () {
            btn.disabled = false;
            result.className = 'enacast-test-result error';
            result.textContent = 'Network error';
        };

        xhr.send('action=enacast_test_connection&nonce=' + encodeURIComponent(enacast_admin.nonce));
    });
})();
