<?php
/**
 * Plugin Name: EnaCast
 * Plugin URI:  https://enacast.com
 * Description: Integrate EnaCast radio platform content into WordPress — podcasts, news, programs, schedule, events, and custom pages.
 * Version:     0.2.0
 * Author:      EnaCast
 * Author URI:  https://enacast.com
 * License:     Proprietary
 * Text Domain: enacast
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'ENACAST_VERSION', '0.2.0' );
define( 'ENACAST_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'ENACAST_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'ENACAST_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

if ( ! defined( 'ENACAST_SEARCH_URL' ) ) {
    define( 'ENACAST_SEARCH_URL', 'https://search.enacast.com' );
}
if ( ! defined( 'ENACAST_SEARCH_API_KEY' ) ) {
    define( 'ENACAST_SEARCH_API_KEY', 'azX92P4d73j0FsXmiytDe3IcFYzsiOLv' );
}

require_once ENACAST_PLUGIN_DIR . 'includes/class-enacast-api-client.php';
require_once ENACAST_PLUGIN_DIR . 'includes/class-enacast-template.php';
require_once ENACAST_PLUGIN_DIR . 'includes/class-enacast-i18n.php';
require_once ENACAST_PLUGIN_DIR . 'includes/class-enacast-settings.php';
require_once ENACAST_PLUGIN_DIR . 'includes/class-enacast-loader.php';

// Shortcodes
require_once ENACAST_PLUGIN_DIR . 'includes/shortcodes/class-enacast-shortcode-programs.php';
require_once ENACAST_PLUGIN_DIR . 'includes/shortcodes/class-enacast-shortcode-program.php';
require_once ENACAST_PLUGIN_DIR . 'includes/shortcodes/class-enacast-shortcode-podcasts.php';
require_once ENACAST_PLUGIN_DIR . 'includes/shortcodes/class-enacast-shortcode-podcast.php';
require_once ENACAST_PLUGIN_DIR . 'includes/shortcodes/class-enacast-shortcode-news.php';
require_once ENACAST_PLUGIN_DIR . 'includes/shortcodes/class-enacast-shortcode-news-article.php';
require_once ENACAST_PLUGIN_DIR . 'includes/shortcodes/class-enacast-shortcode-schedule.php';
require_once ENACAST_PLUGIN_DIR . 'includes/shortcodes/class-enacast-shortcode-now-playing.php';
require_once ENACAST_PLUGIN_DIR . 'includes/shortcodes/class-enacast-shortcode-agenda.php';
require_once ENACAST_PLUGIN_DIR . 'includes/shortcodes/class-enacast-shortcode-page.php';

add_action( 'plugins_loaded', function () {
    $loader = new Enacast_Loader();
    $loader->init();
} );
