<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Loader {

    public function init() {
        // i18n
        $i18n = new Enacast_I18n();
        $i18n->init();

        // Settings
        $settings = new Enacast_Settings();
        $settings->init();

        // Shortcodes
        add_action( 'init', array( $this, 'register_shortcodes' ) );

        // Assets
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_public_assets' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_assets' ) );

        // AJAX
        add_action( 'wp_ajax_enacast_filter', array( $this, 'ajax_filter' ) );
        add_action( 'wp_ajax_nopriv_enacast_filter', array( $this, 'ajax_filter' ) );

        // Gutenberg blocks
        add_action( 'init', array( $this, 'register_blocks' ) );

        // Block category
        add_filter( 'block_categories_all', array( $this, 'register_block_category' ) );
    }

    public function register_shortcodes() {
        add_shortcode( 'enacast_programs', array( 'Enacast_Shortcode_Programs', 'render' ) );
        add_shortcode( 'enacast_program', array( 'Enacast_Shortcode_Program', 'render' ) );
        add_shortcode( 'enacast_podcasts', array( 'Enacast_Shortcode_Podcasts', 'render' ) );
        add_shortcode( 'enacast_podcast', array( 'Enacast_Shortcode_Podcast', 'render' ) );
        add_shortcode( 'enacast_news', array( 'Enacast_Shortcode_News', 'render' ) );
        add_shortcode( 'enacast_news_article', array( 'Enacast_Shortcode_News_Article', 'render' ) );
        add_shortcode( 'enacast_schedule', array( 'Enacast_Shortcode_Schedule', 'render' ) );
        add_shortcode( 'enacast_now_playing', array( 'Enacast_Shortcode_Now_Playing', 'render' ) );
        add_shortcode( 'enacast_agenda', array( 'Enacast_Shortcode_Agenda', 'render' ) );
        add_shortcode( 'enacast_page', array( 'Enacast_Shortcode_Page', 'render' ) );
    }

    public function enqueue_public_assets() {
        wp_enqueue_style(
            'enacast-public',
            ENACAST_PLUGIN_URL . 'assets/css/enacast-public.css',
            array(),
            ENACAST_VERSION
        );

        wp_enqueue_script(
            'enacast-public',
            ENACAST_PLUGIN_URL . 'assets/js/enacast-public.js',
            array(),
            ENACAST_VERSION,
            true
        );

        wp_localize_script( 'enacast-public', 'enacast_ajax', array(
            'ajax_url' => admin_url( 'admin-ajax.php' ),
            'nonce'    => wp_create_nonce( 'enacast_public_nonce' ),
        ) );
    }

    public function enqueue_admin_assets( $hook ) {
        if ( 'settings_page_enacast' !== $hook ) {
            return;
        }

        wp_enqueue_style(
            'enacast-admin',
            ENACAST_PLUGIN_URL . 'assets/css/enacast-admin.css',
            array(),
            ENACAST_VERSION
        );

        wp_enqueue_script(
            'enacast-admin',
            ENACAST_PLUGIN_URL . 'assets/js/enacast-admin.js',
            array(),
            ENACAST_VERSION,
            true
        );

        wp_localize_script( 'enacast-admin', 'enacast_admin', array(
            'ajax_url' => admin_url( 'admin-ajax.php' ),
            'nonce'    => wp_create_nonce( 'enacast_admin_nonce' ),
        ) );
    }

    public function register_blocks() {
        $blocks_dir = ENACAST_PLUGIN_DIR . 'blocks/';
        if ( ! file_exists( $blocks_dir ) ) {
            return;
        }

        $block_shortcode_map = array(
            'programs'     => 'Enacast_Shortcode_Programs',
            'program'      => 'Enacast_Shortcode_Program',
            'podcasts'     => 'Enacast_Shortcode_Podcasts',
            'podcast'      => 'Enacast_Shortcode_Podcast',
            'news'         => 'Enacast_Shortcode_News',
            'news-article' => 'Enacast_Shortcode_News_Article',
            'schedule'     => 'Enacast_Shortcode_Schedule',
            'now-playing'  => 'Enacast_Shortcode_Now_Playing',
            'agenda'       => 'Enacast_Shortcode_Agenda',
            'page'         => 'Enacast_Shortcode_Page',
        );

        foreach ( $block_shortcode_map as $block_name => $shortcode_class ) {
            $block_json = $blocks_dir . $block_name . '/block.json';
            if ( file_exists( $block_json ) ) {
                register_block_type( $block_json, array(
                    'render_callback' => array( $shortcode_class, 'render' ),
                ) );
            }
        }
    }

    public function register_block_category( $categories ) {
        return array_merge( $categories, array(
            array(
                'slug'  => 'enacast',
                'title' => __( 'EnaCast', 'enacast' ),
            ),
        ) );
    }

    public function ajax_filter() {
        check_ajax_referer( 'enacast_public_nonce', 'nonce' );

        $shortcode = isset( $_POST['shortcode'] ) ? sanitize_text_field( $_POST['shortcode'] ) : '';
        $atts_raw  = isset( $_POST['atts'] ) ? $_POST['atts'] : array();

        $atts = array();
        if ( is_array( $atts_raw ) ) {
            foreach ( $atts_raw as $key => $value ) {
                $atts[ sanitize_text_field( $key ) ] = sanitize_text_field( $value );
            }
        }

        $handler_map = array(
            'enacast_programs'    => 'Enacast_Shortcode_Programs',
            'enacast_podcasts'    => 'Enacast_Shortcode_Podcasts',
            'enacast_news'        => 'Enacast_Shortcode_News',
            'enacast_agenda'      => 'Enacast_Shortcode_Agenda',
            'enacast_now_playing' => 'Enacast_Shortcode_Now_Playing',
        );

        if ( ! isset( $handler_map[ $shortcode ] ) ) {
            wp_send_json_error( __( 'Invalid shortcode', 'enacast' ) );
        }

        $class = $handler_map[ $shortcode ];
        $html  = $class::render_content( $atts );

        wp_send_json_success( array( 'html' => $html ) );
    }
}
