<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Template {

    /**
     * Render a template with given arguments.
     *
     * Looks for theme override first: {theme}/enacast/{template}.php
     * Falls back to: {plugin}/templates/{template}.php
     *
     * @param string $template_name Template file name (without .php)
     * @param array  $args          Variables to extract into template scope
     * @return string Rendered HTML
     */
    public static function render( $template_name, $args = array() ) {
        $template_file = $template_name . '.php';

        // Check theme override
        $theme_path = locate_template( 'enacast/' . $template_file );

        if ( $theme_path ) {
            $template_path = $theme_path;
        } else {
            $template_path = ENACAST_PLUGIN_DIR . 'templates/' . $template_file;
        }

        if ( ! file_exists( $template_path ) ) {
            return '<!-- EnaCast: template "' . esc_html( $template_name ) . '" not found -->';
        }

        if ( ! empty( $args ) ) {
            extract( $args, EXTR_SKIP );
        }

        ob_start();
        include $template_path;
        return ob_get_clean();
    }
}
