<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Shortcode_Agenda {

    public static function render( $atts = array() ) {
        $atts = shortcode_atts( array(
            'tag'      => '',
            'per_page' => 20,
            'page'     => '',
        ), $atts, 'enacast_agenda' );

        if ( empty( $atts['page'] ) ) {
            $atts['page'] = isset( $_GET['enacast_page'] ) ? absint( $_GET['enacast_page'] ) : 1;
        }

        return self::render_full( $atts );
    }

    public static function render_content( $atts ) {
        $atts = wp_parse_args( $atts, array(
            'tag'      => '',
            'per_page' => 20,
            'page'     => 1,
        ) );

        $client = Enacast_API_Client::instance();

        $params = array(
            'page_size' => (int) $atts['per_page'],
            'page'      => (int) $atts['page'],
        );

        if ( ! empty( $atts['tag'] ) ) {
            $params['tag'] = $atts['tag'];
        }

        $response = $client->get_agenda( $params );

        if ( is_wp_error( $response ) ) {
            return Enacast_Template::render( 'partials/error', array( 'error' => $response ) );
        }

        $events      = isset( $response['results'] ) ? $response['results'] : array();
        $count       = isset( $response['count'] ) ? (int) $response['count'] : 0;
        $per_page    = (int) $atts['per_page'];
        $current     = (int) $atts['page'];
        $total_pages = $per_page > 0 ? (int) ceil( $count / $per_page ) : 1;

        if ( empty( $events ) ) {
            return Enacast_Template::render( 'partials/no-results', array(
                'message' => __( 'No events found.', 'enacast' ),
            ) );
        }

        $html = Enacast_Template::render( 'agenda-list', array(
            'events' => $events,
        ) );

        $html .= Enacast_Template::render( 'partials/pagination', array(
            'current_page' => $current,
            'total_pages'  => $total_pages,
            'count'        => $count,
        ) );

        return $html;
    }

    public static function render_full( $atts ) {
        $content = self::render_content( $atts );

        // Fetch tags for dropdown
        $client = Enacast_API_Client::instance();
        $tag_options = array();
        $tags_response = $client->get_agenda_tags( array( 'page_size' => 100 ) );
        if ( ! is_wp_error( $tags_response ) && isset( $tags_response['results'] ) ) {
            foreach ( $tags_response['results'] as $tag ) {
                $tag_options[] = array(
                    'value' => $tag['slug'],
                    'label' => $tag['title'],
                );
            }
        }

        $filters = array(
            array( 'type' => 'select', 'name' => 'tag', 'placeholder' => __( 'All tags', 'enacast' ), 'options' => $tag_options ),
        );

        $filter_bar = Enacast_Template::render( 'partials/filter-bar', array(
            'filters' => $filters,
        ) );

        return '<div class="enacast-container" data-enacast-filterable data-enacast-shortcode="enacast_agenda" data-enacast-atts="' . esc_attr( wp_json_encode( $atts ) ) . '">'
            . $filter_bar
            . '<div class="enacast-content">' . $content . '</div>'
            . '</div>';
    }
}
