<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Shortcode_News_Article {

    public static function render( $atts = array() ) {
        $atts = shortcode_atts( array(
            'id'   => '',
            'slug' => '',
        ), $atts, 'enacast_news_article' );

        if ( empty( $atts['id'] ) && empty( $atts['slug'] ) ) {
            $atts['id'] = isset( $_GET['article_id'] ) ? sanitize_text_field( $_GET['article_id'] ) : '';
        }

        if ( empty( $atts['id'] ) && empty( $atts['slug'] ) ) {
            return Enacast_Template::render( 'partials/no-results', array(
                'message' => __( 'No article specified.', 'enacast' ),
            ) );
        }

        $client = Enacast_API_Client::instance();

        if ( ! empty( $atts['slug'] ) ) {
            // Lookup by slug via list endpoint
            $response = $client->get_news( array( 'slug' => $atts['slug'], 'page_size' => 1 ) );
            if ( is_wp_error( $response ) ) {
                return Enacast_Template::render( 'partials/error', array( 'error' => $response ) );
            }
            if ( empty( $response['results'] ) ) {
                return Enacast_Template::render( 'partials/no-results', array(
                    'message' => __( 'Article not found.', 'enacast' ),
                ) );
            }
            $article = $response['results'][0];
        } else {
            $article = $client->get_news_article( $atts['id'] );
            if ( is_wp_error( $article ) ) {
                return Enacast_Template::render( 'partials/error', array( 'error' => $article ) );
            }
        }

        return Enacast_Template::render( 'news-article', array(
            'article'  => $article,
            'news_url' => Enacast_Settings::get_page_url( 'news' ),
        ) );
    }
}
