<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Shortcode_News {

    public static function render( $atts = array() ) {
        $atts = shortcode_atts( array(
            'tag'      => '',
            'search'   => '',
            'year'     => '',
            'month'    => '',
            'per_page' => 20,
            'page'     => '',
        ), $atts, 'enacast_news' );

        if ( empty( $atts['page'] ) ) {
            $atts['page'] = isset( $_GET['enacast_page'] ) ? absint( $_GET['enacast_page'] ) : 1;
        }

        return self::render_full( $atts );
    }

    public static function render_content( $atts ) {
        $atts = wp_parse_args( $atts, array(
            'tag'      => '',
            'search'   => '',
            'year'     => '',
            'month'    => '',
            'per_page' => 20,
            'page'     => 1,
        ) );

        $client = Enacast_API_Client::instance();

        // Use Typesense for search queries, DRF API for browsing/filtering
        if ( ! empty( $atts['search'] ) ) {
            $search_params = array(
                'per_page' => (int) $atts['per_page'],
                'page'     => (int) $atts['page'],
            );
            if ( ! empty( $atts['tag'] ) ) {
                $search_params['tag'] = $atts['tag'];
            }
            $response = $client->search_news( $atts['search'], $search_params );
        } else {
            $params = array(
                'page_size' => (int) $atts['per_page'],
                'page'      => (int) $atts['page'],
            );

            if ( ! empty( $atts['tag'] ) ) {
                $params['tag'] = $atts['tag'];
            }
            if ( ! empty( $atts['year'] ) ) {
                $params['y'] = (int) $atts['year'];
            }
            if ( ! empty( $atts['month'] ) ) {
                $params['m'] = (int) $atts['month'];
            }

            $response = $client->get_news( $params );
        }

        if ( is_wp_error( $response ) ) {
            return Enacast_Template::render( 'partials/error', array( 'error' => $response ) );
        }

        $articles    = isset( $response['results'] ) ? $response['results'] : array();
        $count       = isset( $response['count'] ) ? (int) $response['count'] : 0;
        $per_page    = (int) $atts['per_page'];
        $current     = (int) $atts['page'];
        $total_pages = $per_page > 0 ? (int) ceil( $count / $per_page ) : 1;

        if ( empty( $articles ) ) {
            return Enacast_Template::render( 'partials/no-results', array(
                'message' => __( 'No articles found.', 'enacast' ),
            ) );
        }

        $html = Enacast_Template::render( 'news-list', array(
            'articles' => $articles,
        ) );

        $html .= Enacast_Template::render( 'partials/pagination', array(
            'current_page' => $current,
            'total_pages'  => $total_pages,
            'count'        => $count,
        ) );

        return $html;
    }

    public static function render_full( $atts ) {
        $content = self::render_content( $atts );

        // Fetch tags for dropdown
        $client = Enacast_API_Client::instance();
        $tag_options = array();
        $tags_response = $client->get_news_tags( array( 'page_size' => 100 ) );
        if ( ! is_wp_error( $tags_response ) && isset( $tags_response['results'] ) ) {
            foreach ( $tags_response['results'] as $tag ) {
                $tag_options[] = array(
                    'value' => $tag['slug'],
                    'label' => $tag['title'],
                );
            }
        }

        // Build year options (from 2015 to current year)
        $current_year = (int) date( 'Y' );
        $year_options = array();
        for ( $y = $current_year; $y >= 2015; $y-- ) {
            $year_options[] = array( 'value' => (string) $y, 'label' => (string) $y );
        }

        // Build month options
        $month_options = array();
        for ( $m = 1; $m <= 12; $m++ ) {
            $month_options[] = array(
                'value' => (string) $m,
                'label' => date_i18n( 'F', mktime( 0, 0, 0, $m, 1 ) ),
            );
        }

        $filters = array(
            array( 'type' => 'search', 'name' => 'search', 'placeholder' => __( 'Search articles...', 'enacast' ) ),
            array( 'type' => 'select', 'name' => 'tag', 'placeholder' => __( 'All tags', 'enacast' ), 'options' => $tag_options ),
            array( 'type' => 'select', 'name' => 'year', 'placeholder' => __( 'All years', 'enacast' ), 'options' => $year_options ),
            array( 'type' => 'select', 'name' => 'month', 'placeholder' => __( 'All months', 'enacast' ), 'options' => $month_options ),
        );

        $filter_bar = Enacast_Template::render( 'partials/filter-bar', array(
            'filters' => $filters,
        ) );

        return '<div class="enacast-container" data-enacast-filterable data-enacast-shortcode="enacast_news" data-enacast-atts="' . esc_attr( wp_json_encode( $atts ) ) . '">'
            . $filter_bar
            . '<div class="enacast-content">' . $content . '</div>'
            . '</div>';
    }
}
