<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Shortcode_Now_Playing {

    public static function render( $atts = array() ) {
        $atts = shortcode_atts( array(
            'show_next' => 'true',
            'refresh'   => 0,
        ), $atts, 'enacast_now_playing' );

        return self::render_content( $atts );
    }

    public static function render_content( $atts = array() ) {
        $atts = wp_parse_args( $atts, array(
            'show_next' => 'true',
            'refresh'   => 0,
        ) );

        $client   = Enacast_API_Client::instance();
        $response = $client->get_now_playing();

        if ( is_wp_error( $response ) ) {
            return Enacast_Template::render( 'partials/error', array( 'error' => $response ) );
        }

        return Enacast_Template::render( 'now-playing', array(
            'data'         => $response,
            'show_next'    => filter_var( $atts['show_next'], FILTER_VALIDATE_BOOLEAN ),
            'refresh'      => (int) $atts['refresh'],
            'schedule_url' => Enacast_Settings::get_page_url( 'schedule' ),
        ) );
    }
}
