<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Shortcode_Page {

    public static function render( $atts = array() ) {
        $atts = shortcode_atts( array(
            'slug' => '',
        ), $atts, 'enacast_page' );

        if ( empty( $atts['slug'] ) ) {
            $atts['slug'] = isset( $_GET['enacast_page_slug'] ) ? sanitize_text_field( $_GET['enacast_page_slug'] ) : '';
        }

        if ( empty( $atts['slug'] ) ) {
            return Enacast_Template::render( 'partials/no-results', array(
                'message' => __( 'No page specified.', 'enacast' ),
            ) );
        }

        $client   = Enacast_API_Client::instance();
        $response = $client->get_custom_page( $atts['slug'] );

        if ( is_wp_error( $response ) ) {
            return Enacast_Template::render( 'partials/error', array( 'error' => $response ) );
        }

        // Custom pages uses list endpoint with slug filter
        $pages = isset( $response['results'] ) ? $response['results'] : array();
        if ( empty( $pages ) ) {
            return Enacast_Template::render( 'partials/no-results', array(
                'message' => __( 'Page not found.', 'enacast' ),
            ) );
        }

        $page_data = $pages[0];

        return Enacast_Template::render( 'page-content', array(
            'page_data' => $page_data,
        ) );
    }
}
