<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Shortcode_Podcast {

    public static function render( $atts = array() ) {
        $atts = shortcode_atts( array(
            'id' => '',
        ), $atts, 'enacast_podcast' );

        if ( empty( $atts['id'] ) ) {
            $atts['id'] = isset( $_GET['podcast_id'] ) ? sanitize_text_field( $_GET['podcast_id'] ) : '';
        }

        if ( empty( $atts['id'] ) ) {
            return Enacast_Template::render( 'partials/no-results', array(
                'message' => __( 'No episode specified.', 'enacast' ),
            ) );
        }

        $client  = Enacast_API_Client::instance();
        $podcast = $client->get_podcast( $atts['id'] );

        if ( is_wp_error( $podcast ) ) {
            return Enacast_Template::render( 'partials/error', array( 'error' => $podcast ) );
        }

        return Enacast_Template::render( 'podcast-single', array(
            'podcast'      => $podcast,
            'podcasts_url' => Enacast_Settings::get_page_url( 'podcasts' ),
        ) );
    }
}
