<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Shortcode_Podcasts {

    public static function render( $atts = array() ) {
        $atts = shortcode_atts( array(
            'program'  => '',
            'search'   => '',
            'per_page' => 20,
            'page'     => '',
        ), $atts, 'enacast_podcasts' );

        if ( empty( $atts['page'] ) ) {
            $atts['page'] = isset( $_GET['enacast_page'] ) ? absint( $_GET['enacast_page'] ) : 1;
        }

        return self::render_full( $atts );
    }

    public static function render_content( $atts ) {
        $atts = wp_parse_args( $atts, array(
            'program'  => '',
            'search'   => '',
            'per_page' => 20,
            'page'     => 1,
        ) );

        $client = Enacast_API_Client::instance();

        // Use Typesense for search queries, DRF API for browsing/filtering
        if ( ! empty( $atts['search'] ) ) {
            $search_params = array(
                'per_page' => (int) $atts['per_page'],
                'page'     => (int) $atts['page'],
            );
            if ( ! empty( $atts['program'] ) ) {
                $search_params['program'] = $atts['program'];
            }
            $response = $client->search_podcasts( $atts['search'], $search_params );
        } else {
            $params = array(
                'page_size' => (int) $atts['per_page'],
                'page'      => (int) $atts['page'],
            );

            if ( ! empty( $atts['program'] ) ) {
                $params['program'] = $atts['program'];
            }

            $response = $client->get_podcasts( $params );
        }

        if ( is_wp_error( $response ) ) {
            return Enacast_Template::render( 'partials/error', array( 'error' => $response ) );
        }

        $podcasts    = isset( $response['results'] ) ? $response['results'] : array();
        $count       = isset( $response['count'] ) ? (int) $response['count'] : 0;
        $per_page    = (int) $atts['per_page'];
        $current     = (int) $atts['page'];
        $total_pages = $per_page > 0 ? (int) ceil( $count / $per_page ) : 1;

        if ( empty( $podcasts ) ) {
            return Enacast_Template::render( 'partials/no-results', array(
                'message' => __( 'No episodes found.', 'enacast' ),
            ) );
        }

        $html = Enacast_Template::render( 'podcasts-list', array(
            'podcasts' => $podcasts,
        ) );

        $html .= Enacast_Template::render( 'partials/pagination', array(
            'current_page' => $current,
            'total_pages'  => $total_pages,
            'count'        => $count,
        ) );

        return $html;
    }

    public static function render_full( $atts ) {
        $content = self::render_content( $atts );

        // Fetch programs for dropdown
        $client = Enacast_API_Client::instance();
        $program_options = array();
        $programs_response = $client->get_programs( array( 'page_size' => 200, 'onair' => 'true' ) );
        if ( ! is_wp_error( $programs_response ) && isset( $programs_response['results'] ) ) {
            foreach ( $programs_response['results'] as $prog ) {
                $program_options[] = array(
                    'value' => isset( $prog['codename'] ) ? $prog['codename'] : '',
                    'label' => isset( $prog['name'] ) ? $prog['name'] : $prog['codename'],
                );
            }
        }

        $filters = array(
            array( 'type' => 'search', 'name' => 'search', 'placeholder' => __( 'Search episodes...', 'enacast' ) ),
            array( 'type' => 'searchable-select', 'name' => 'program', 'placeholder' => __( 'All programs', 'enacast' ), 'options' => $program_options ),
        );

        $filter_bar = Enacast_Template::render( 'partials/filter-bar', array(
            'filters' => $filters,
        ) );

        return '<div class="enacast-container" data-enacast-filterable data-enacast-shortcode="enacast_podcasts" data-enacast-atts="' . esc_attr( wp_json_encode( $atts ) ) . '">'
            . $filter_bar
            . '<div class="enacast-content">' . $content . '</div>'
            . '</div>';
    }
}
