<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Shortcode_Program {

    public static function render( $atts = array() ) {
        $atts = shortcode_atts( array(
            'codename'      => '',
            'show_podcasts' => 'true',
            'podcast_count' => 5,
        ), $atts, 'enacast_program' );

        if ( empty( $atts['codename'] ) ) {
            $atts['codename'] = isset( $_GET['program'] ) ? sanitize_text_field( $_GET['program'] ) : '';
        }

        if ( empty( $atts['codename'] ) ) {
            return Enacast_Template::render( 'partials/no-results', array(
                'message' => __( 'No program specified.', 'enacast' ),
            ) );
        }

        $client  = Enacast_API_Client::instance();
        $program = $client->get_program( $atts['codename'] );

        if ( is_wp_error( $program ) ) {
            return Enacast_Template::render( 'partials/error', array( 'error' => $program ) );
        }

        $podcasts = array();
        if ( filter_var( $atts['show_podcasts'], FILTER_VALIDATE_BOOLEAN ) ) {
            $podcast_response = $client->get_podcasts( array(
                'program'   => $atts['codename'],
                'page_size' => (int) $atts['podcast_count'],
            ) );
            if ( ! is_wp_error( $podcast_response ) && isset( $podcast_response['results'] ) ) {
                $podcasts = $podcast_response['results'];
            }
        }

        $rss_url = '';
        $radio_codename = get_option( 'enacast_radio_codename', '' );
        if ( $radio_codename && ! empty( $program['codename'] ) ) {
            $rss_url = 'https://' . sanitize_text_field( $radio_codename ) . '.radio.enacast.fm/podcasts/' . sanitize_text_field( $program['codename'] ) . '/rss/';
        }

        $subscribe = array();
        foreach ( array_keys( Enacast_Settings::get_subscribe_platforms() ) as $key ) {
            if ( Enacast_Settings::is_subscribe_enabled( $key ) ) {
                $subscribe[] = $key;
            }
        }

        return Enacast_Template::render( 'program-single', array(
            'program'      => $program,
            'podcasts'     => $podcasts,
            'podcasts_url' => Enacast_Settings::get_page_url( 'podcasts' ),
            'rss_url'      => $rss_url,
            'subscribe'    => $subscribe,
        ) );
    }
}
