<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Shortcode_Programs {

    public static function render( $atts = array() ) {
        $atts = shortcode_atts( array(
            'onair'    => '1',
            'featured' => '',
            'search'   => '',
            'per_page' => 20,
            'page'     => '',
        ), $atts, 'enacast_programs' );

        // Allow URL params to override
        if ( empty( $atts['page'] ) ) {
            $atts['page'] = isset( $_GET['enacast_page'] ) ? absint( $_GET['enacast_page'] ) : 1;
        }

        return self::render_full( $atts );
    }

    public static function render_content( $atts ) {
        $atts = wp_parse_args( $atts, array(
            'onair'    => '1',
            'featured' => '',
            'search'   => '',
            'per_page' => 20,
            'page'     => 1,
        ) );

        $client = Enacast_API_Client::instance();

        $params = array(
            'page_size' => (int) $atts['per_page'],
            'page'      => (int) $atts['page'],
        );

        if ( '' !== $atts['onair'] ) {
            $params['onair'] = $atts['onair'] ? 'true' : 'false';
        }
        if ( '' !== $atts['featured'] ) {
            $params['featured'] = $atts['featured'] ? 'true' : 'false';
        }
        if ( ! empty( $atts['search'] ) ) {
            $params['search'] = $atts['search'];
        }

        $response = $client->get_programs( $params );

        if ( is_wp_error( $response ) ) {
            return Enacast_Template::render( 'partials/error', array( 'error' => $response ) );
        }

        $programs   = isset( $response['results'] ) ? $response['results'] : array();

        // Sort featured programs first
        usort( $programs, function ( $a, $b ) {
            $af = ! empty( $a['featured'] ) ? 1 : 0;
            $bf = ! empty( $b['featured'] ) ? 1 : 0;
            return $bf - $af;
        } );

        $count      = isset( $response['count'] ) ? (int) $response['count'] : 0;
        $per_page   = (int) $atts['per_page'];
        $current    = (int) $atts['page'];
        $total_pages = $per_page > 0 ? (int) ceil( $count / $per_page ) : 1;

        if ( empty( $programs ) ) {
            return Enacast_Template::render( 'partials/no-results', array(
                'message' => __( 'No programs found.', 'enacast' ),
            ) );
        }

        $html = Enacast_Template::render( 'programs-list', array(
            'programs' => $programs,
        ) );

        $html .= Enacast_Template::render( 'partials/pagination', array(
            'current_page' => $current,
            'total_pages'  => $total_pages,
            'count'        => $count,
        ) );

        return $html;
    }

    public static function render_full( $atts ) {
        $content = self::render_content( $atts );

        $filters = array(
            array( 'type' => 'search', 'name' => 'search', 'placeholder' => __( 'Search programs...', 'enacast' ) ),
            array( 'type' => 'toggle', 'name' => 'onair', 'label' => __( 'On air', 'enacast' ), 'checked' => true ),
            array( 'type' => 'toggle', 'name' => 'featured', 'label' => __( 'Featured', 'enacast' ) ),
        );

        $filter_bar = Enacast_Template::render( 'partials/filter-bar', array(
            'filters' => $filters,
        ) );

        return '<div class="enacast-container" data-enacast-filterable data-enacast-shortcode="enacast_programs" data-enacast-atts="' . esc_attr( wp_json_encode( $atts ) ) . '">'
            . $filter_bar
            . '<div class="enacast-content">' . $content . '</div>'
            . '</div>';
    }
}
