<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Enacast_Shortcode_Schedule {

    public static function render( $atts = array() ) {
        $atts = shortcode_atts( array(
            'week' => '',
            'year' => '',
        ), $atts, 'enacast_schedule' );

        // Allow URL navigation
        if ( empty( $atts['week'] ) && isset( $_GET['enacast_week'] ) ) {
            $atts['week'] = absint( $_GET['enacast_week'] );
        }
        if ( empty( $atts['year'] ) && isset( $_GET['enacast_year'] ) ) {
            $atts['year'] = absint( $_GET['enacast_year'] );
        }

        $year = ! empty( $atts['year'] ) ? (int) $atts['year'] : (int) date( 'o' );
        $week = ! empty( $atts['week'] ) ? (int) $atts['week'] : (int) date( 'W' );

        $client   = Enacast_API_Client::instance();
        $response = $client->get_schedule_week( $year, $week );

        if ( is_wp_error( $response ) ) {
            return Enacast_Template::render( 'partials/error', array( 'error' => $response ) );
        }

        // Calculate prev/next week
        $dt = new DateTime();
        $dt->setISODate( $year, $week );
        $current_monday = $dt->format( 'Y-m-d' );

        // Human-readable date range and per-day dates
        $week_start = date_i18n( 'M j', $dt->getTimestamp() );
        $day_dates  = array();
        for ( $d = 1; $d <= 7; $d++ ) {
            $day_dt = clone $dt;
            $day_dt->setISODate( $year, $week, $d );
            $day_dates[ $d ] = (int) $day_dt->format( 'j' );
        }
        $dt_sunday  = clone $dt;
        $dt_sunday->setISODate( $year, $week, 7 );
        $week_end   = date_i18n( 'M j, Y', $dt_sunday->getTimestamp() );

        $dt->setISODate( $year, $week );
        $dt->modify( '-7 days' );
        $prev_year = (int) $dt->format( 'o' );
        $prev_week = (int) $dt->format( 'W' );

        $dt->modify( '+14 days' );
        $next_year = (int) $dt->format( 'o' );
        $next_week = (int) $dt->format( 'W' );

        return Enacast_Template::render( 'schedule-week', array(
            'schedule'       => $response,
            'year'           => $year,
            'week'           => $week,
            'current_monday' => $current_monday,
            'week_start'     => $week_start,
            'week_end'       => $week_end,
            'day_dates'      => $day_dates,
            'prev_year'      => $prev_year,
            'prev_week'      => $prev_week,
            'next_year'      => $next_year,
            'next_week'      => $next_week,
        ) );
    }
}
