<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="enacast-grid enacast-agenda-grid">
    <?php foreach ( $events as $event ) : ?>
        <div class="enacast-card enacast-agenda-card <?php echo ! empty( $event['pinned'] ) ? 'enacast-card-pinned' : ''; ?>">
            <?php if ( ! empty( $event['main_image_square_thumb_256'] ) ) : ?>
                <div class="enacast-card-image">
                    <img src="<?php echo esc_url( $event['main_image_square_thumb_256'] ); ?>"
                         alt="<?php echo esc_attr( $event['title'] ); ?>"
                         loading="lazy" />
                </div>
            <?php endif; ?>

            <div class="enacast-card-body">
                <?php if ( ! empty( $event['pinned'] ) ) : ?>
                    <span class="enacast-badge enacast-badge-pinned"><?php esc_html_e( 'Pinned', 'enacast' ); ?></span>
                <?php endif; ?>

                <h3 class="enacast-card-title"><?php echo esc_html( $event['title'] ); ?></h3>

                <?php if ( ! empty( $event['description'] ) ) : ?>
                    <p class="enacast-card-description"><?php echo esc_html( $event['description'] ); ?></p>
                <?php endif; ?>

                <?php if ( ! empty( $event['place'] ) ) : ?>
                    <p class="enacast-card-meta enacast-agenda-place"><?php echo esc_html( $event['place'] ); ?></p>
                <?php endif; ?>

                <div class="enacast-agenda-dates">
                    <?php if ( ! empty( $event['datetime_start'] ) ) : ?>
                        <time class="enacast-agenda-start" datetime="<?php echo esc_attr( $event['datetime_start'] ); ?>">
                            <?php echo esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $event['datetime_start'] ) ) ); ?>
                        </time>
                    <?php endif; ?>
                    <?php if ( ! empty( $event['datetime_end'] ) ) : ?>
                        <span> — </span>
                        <time class="enacast-agenda-end" datetime="<?php echo esc_attr( $event['datetime_end'] ); ?>">
                            <?php echo esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $event['datetime_end'] ) ) ); ?>
                        </time>
                    <?php endif; ?>
                </div>

                <?php if ( ! empty( $event['tags'] ) ) : ?>
                    <div class="enacast-tags">
                        <?php foreach ( $event['tags'] as $tag ) : ?>
                            <span class="enacast-tag"><?php echo esc_html( $tag['title'] ); ?></span>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <?php if ( ! empty( $event['more_info_url'] ) ) : ?>
                    <a href="<?php echo esc_url( $event['more_info_url'] ); ?>" target="_blank" rel="noopener" class="enacast-agenda-link">
                        <?php esc_html_e( 'More info', 'enacast' ); ?>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>
