<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<article class="enacast-news-article">
    <?php if ( ! empty( $news_url ) ) : ?>
        <nav class="enacast-back-link">
            <a href="<?php echo esc_url( $news_url ); ?>">&larr; <?php esc_html_e( 'Back to news', 'enacast' ); ?></a>
        </nav>
    <?php endif; ?>

    <?php if ( ! empty( $article['main_image_url'] ) ) : ?>
        <div class="enacast-article-hero">
            <img src="<?php echo esc_url( $article['main_image_url'] ); ?>"
                 alt="<?php echo esc_attr( $article['headline'] ); ?>" />
        </div>
    <?php endif; ?>

    <header class="enacast-article-header">
        <h2 class="enacast-article-title"><?php echo esc_html( $article['headline'] ); ?></h2>

        <?php if ( ! empty( $article['sub_headline'] ) ) : ?>
            <p class="enacast-article-subtitle"><?php echo esc_html( $article['sub_headline'] ); ?></p>
        <?php endif; ?>

        <div class="enacast-article-meta">
            <?php if ( ! empty( $article['created'] ) ) : ?>
                <time datetime="<?php echo esc_attr( $article['created'] ); ?>">
                    <?php echo esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $article['created'] ) ) ); ?>
                </time>
            <?php endif; ?>

            <?php if ( ! empty( $article['tags'] ) ) : ?>
                <div class="enacast-tags">
                    <?php foreach ( $article['tags'] as $tag ) : ?>
                        <span class="enacast-tag"><?php echo esc_html( $tag['title'] ); ?></span>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </header>

    <div class="enacast-article-body">
        <?php echo wp_kses_post( $article['body'] ); ?>
    </div>
</article>
