<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="enacast-grid enacast-news-grid">
    <?php foreach ( $articles as $article ) : ?>
        <div class="enacast-card enacast-news-card <?php echo ! empty( $article['pinned'] ) ? 'enacast-card-pinned' : ''; ?>">
            <?php if ( ! empty( $article['main_image_cropped_landscape'] ) ) : ?>
                <div class="enacast-card-image">
                    <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'news_article', 'article_id', $article['id'] ) ); ?>">
                        <img src="<?php echo esc_url( $article['main_image_cropped_landscape'] ); ?>"
                             alt="<?php echo esc_attr( $article['headline'] ); ?>"
                             loading="lazy" />
                    </a>
                </div>
            <?php endif; ?>

            <div class="enacast-card-body">
                <?php if ( ! empty( $article['pinned'] ) ) : ?>
                    <span class="enacast-badge enacast-badge-pinned"><?php esc_html_e( 'Pinned', 'enacast' ); ?></span>
                <?php endif; ?>

                <h3 class="enacast-card-title">
                    <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'news_article', 'article_id', $article['id'] ) ); ?>">
                        <?php echo esc_html( $article['headline'] ); ?>
                    </a>
                </h3>

                <?php if ( ! empty( $article['sub_headline'] ) ) : ?>
                    <p class="enacast-card-subtitle"><?php echo esc_html( $article['sub_headline'] ); ?></p>
                <?php endif; ?>

                <?php if ( ! empty( $article['unformatted_short_body'] ) ) : ?>
                    <p class="enacast-card-description"><?php echo esc_html( $article['unformatted_short_body'] ); ?></p>
                <?php endif; ?>

                <div class="enacast-card-footer">
                    <?php if ( ! empty( $article['created'] ) ) : ?>
                        <time class="enacast-card-meta" datetime="<?php echo esc_attr( $article['created'] ); ?>">
                            <?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $article['created'] ) ) ); ?>
                        </time>
                    <?php endif; ?>

                    <?php if ( ! empty( $article['tags'] ) ) : ?>
                        <div class="enacast-tags">
                            <?php foreach ( $article['tags'] as $tag ) : ?>
                                <span class="enacast-tag"><?php echo esc_html( $tag['title'] ); ?></span>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>
