<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="enacast-now-playing" <?php if ( $refresh > 0 ) : ?>data-enacast-refresh="<?php echo esc_attr( $refresh ); ?>"<?php endif; ?>>
    <?php if ( ! empty( $data['current_program'] ) ) :
        $program  = $data['current_program'];
        $sched    = isset( $data['current_schedule'] ) ? $data['current_schedule'] : null;
        $is_out_of_schedule = ! empty( $program['codename'] ) && substr( $program['codename'], -16 ) === '_out_of_schedule';
    ?>
        <?php if ( ! empty( $program['cover_big_landscape'] ) ) : ?>
            <div class="enacast-now-playing-hero">
                <img src="<?php echo esc_url( $program['cover_big_landscape'] ); ?>"
                     alt="<?php echo esc_attr( $program['name'] ); ?>" />
            </div>
        <?php endif; ?>

        <div class="enacast-now-playing-current">
            <div class="enacast-now-playing-program">
                <?php if ( ! empty( $program['logo_square_400'] ) ) : ?>
                    <img class="enacast-now-playing-logo"
                         src="<?php echo esc_url( $program['logo_square_400'] ); ?>"
                         alt="<?php echo esc_attr( $program['name'] ); ?>" />
                <?php endif; ?>
                <div class="enacast-now-playing-info">
                    <?php if ( ! $is_out_of_schedule ) : ?>
                        <span class="enacast-now-playing-live">
                            <span class="enacast-live-dot"></span>
                            <?php esc_html_e( 'Live', 'enacast' ); ?>
                        </span>
                    <?php endif; ?>
                    <h2 class="enacast-now-playing-name">
                        <?php if ( $is_out_of_schedule ) : ?>
                            <?php echo esc_html( $program['name'] ); ?>
                        <?php else : ?>
                            <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'program', 'program', $program['codename'] ) ); ?>">
                                <?php echo esc_html( $program['name'] ); ?>
                            </a>
                        <?php endif; ?>
                    </h2>
                    <?php if ( $sched && ! empty( $sched['start_time_local'] ) ) : ?>
                        <span class="enacast-now-playing-time">
                            <?php echo esc_html( substr( $sched['start_time_local'], 0, 5 ) ); ?>
                            <?php if ( ! empty( $sched['end_time_local'] ) ) : ?>
                                – <?php echo esc_html( substr( $sched['end_time_local'], 0, 5 ) ); ?>
                            <?php endif; ?>
                        </span>
                    <?php endif; ?>
                    <?php if ( ! empty( $data['repetition'] ) ) : ?>
                        <span class="enacast-badge enacast-badge-repeat"><?php esc_html_e( 'Repeat', 'enacast' ); ?></span>
                    <?php endif; ?>
                    <?php if ( ! empty( $program['descripcio'] ) ) : ?>
                        <p class="enacast-now-playing-description"><?php echo esc_html( $program['descripcio'] ); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php else : ?>
        <div class="enacast-now-playing-current">
            <p><?php esc_html_e( 'No broadcast right now.', 'enacast' ); ?></p>
        </div>
    <?php endif; ?>

    <?php if ( $show_next ) : ?>
        <?php if ( ! empty( $data['next_program'] ) ) :
            $next_program = $data['next_program'];
            $next_sched   = isset( $data['next_schedule'] ) ? $data['next_schedule'] : null;
            $next_out_of_schedule = ! empty( $next_program['codename'] ) && substr( $next_program['codename'], -16 ) === '_out_of_schedule';
        ?>
            <div class="enacast-now-playing-next">
                <h4 class="enacast-now-playing-label"><?php esc_html_e( 'Up next', 'enacast' ); ?></h4>
                <div class="enacast-now-playing-program">
                    <?php if ( ! empty( $next_program['logo_square_400'] ) ) : ?>
                        <img class="enacast-now-playing-logo enacast-now-playing-logo-sm"
                             src="<?php echo esc_url( $next_program['logo_square_400'] ); ?>"
                             alt="<?php echo esc_attr( $next_program['name'] ); ?>" />
                    <?php endif; ?>
                    <div class="enacast-now-playing-info">
                        <span class="enacast-now-playing-name enacast-now-playing-name-sm">
                            <?php if ( $next_out_of_schedule ) : ?>
                                <?php echo esc_html( $next_program['name'] ); ?>
                            <?php else : ?>
                                <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'program', 'program', $next_program['codename'] ) ); ?>">
                                    <?php echo esc_html( $next_program['name'] ); ?>
                                </a>
                            <?php endif; ?>
                        </span>
                        <?php if ( $next_sched && ! empty( $next_sched['start_time_local'] ) ) : ?>
                            <span class="enacast-now-playing-time">
                                <?php echo esc_html( substr( $next_sched['start_time_local'], 0, 5 ) ); ?>
                                <?php if ( ! empty( $next_sched['end_time_local'] ) ) : ?>
                                    – <?php echo esc_html( substr( $next_sched['end_time_local'], 0, 5 ) ); ?>
                                <?php endif; ?>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php elseif ( ! empty( $schedule_url ) ) : ?>
            <div class="enacast-now-playing-next">
                <h4 class="enacast-now-playing-label"><?php esc_html_e( 'Up next', 'enacast' ); ?></h4>
                <a class="enacast-now-playing-schedule-link" href="<?php echo esc_url( $schedule_url ); ?>">
                    <?php esc_html_e( 'Check our full schedule', 'enacast' ); ?> →
                </a>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>
