<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<?php if ( ! empty( $filters ) ) : ?>
<div class="enacast-filters">
    <form class="enacast-filter-form" method="get">
        <?php foreach ( $filters as $filter ) : ?>
            <?php if ( 'search' === $filter['type'] ) : ?>
                <input type="search"
                       name="<?php echo esc_attr( $filter['name'] ); ?>"
                       placeholder="<?php echo esc_attr( $filter['placeholder'] ); ?>"
                       class="enacast-filter-search"
                       value="" />
            <?php elseif ( 'text' === $filter['type'] ) : ?>
                <input type="text"
                       name="<?php echo esc_attr( $filter['name'] ); ?>"
                       placeholder="<?php echo esc_attr( $filter['placeholder'] ); ?>"
                       class="enacast-filter-text"
                       value="" />
            <?php elseif ( 'toggle' === $filter['type'] ) : ?>
                <label class="enacast-filter-toggle">
                    <input type="checkbox" name="<?php echo esc_attr( $filter['name'] ); ?>" value="1"<?php if ( ! empty( $filter['checked'] ) ) echo ' checked'; ?> />
                    <?php echo esc_html( $filter['label'] ); ?>
                </label>
            <?php elseif ( 'select' === $filter['type'] ) : ?>
                <select name="<?php echo esc_attr( $filter['name'] ); ?>" class="enacast-filter-select">
                    <option value=""><?php echo esc_html( $filter['placeholder'] ); ?></option>
                    <?php if ( ! empty( $filter['options'] ) ) : ?>
                        <?php foreach ( $filter['options'] as $opt ) : ?>
                            <option value="<?php echo esc_attr( $opt['value'] ); ?>">
                                <?php echo esc_html( $opt['label'] ); ?>
                            </option>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </select>
            <?php elseif ( 'searchable-select' === $filter['type'] ) : ?>
                <div class="enacast-searchable-select" data-name="<?php echo esc_attr( $filter['name'] ); ?>">
                    <input type="hidden" name="<?php echo esc_attr( $filter['name'] ); ?>" value="" class="enacast-searchable-select-value" />
                    <input type="text"
                           placeholder="<?php echo esc_attr( $filter['placeholder'] ); ?>"
                           class="enacast-searchable-select-input"
                           autocomplete="off" />
                    <div class="enacast-searchable-select-dropdown">
                        <div class="enacast-searchable-select-option" data-value="">
                            <?php echo esc_html( $filter['placeholder'] ); ?>
                        </div>
                        <?php if ( ! empty( $filter['options'] ) ) : ?>
                            <?php foreach ( $filter['options'] as $opt ) : ?>
                                <div class="enacast-searchable-select-option" data-value="<?php echo esc_attr( $opt['value'] ); ?>">
                                    <?php echo esc_html( $opt['label'] ); ?>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            <?php elseif ( 'number' === $filter['type'] ) : ?>
                <input type="number"
                       name="<?php echo esc_attr( $filter['name'] ); ?>"
                       placeholder="<?php echo esc_attr( $filter['placeholder'] ); ?>"
                       class="enacast-filter-number"
                       value="" />
            <?php endif; ?>
        <?php endforeach; ?>
        <button type="submit" class="enacast-filter-submit"><?php esc_html_e( 'Filter', 'enacast' ); ?></button>
    </form>
</div>
<?php endif; ?>
