<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<?php if ( $total_pages > 1 ) : ?>
<nav class="enacast-pagination" aria-label="<?php esc_attr_e( 'Pagination', 'enacast' ); ?>">
    <?php if ( $current_page > 1 ) : ?>
        <a href="<?php echo esc_url( add_query_arg( 'enacast_page', $current_page - 1 ) ); ?>"
           class="enacast-pagination-link enacast-pagination-prev"
           data-page="<?php echo esc_attr( $current_page - 1 ); ?>">
            &laquo; <?php esc_html_e( 'Previous', 'enacast' ); ?>
        </a>
    <?php endif; ?>

    <span class="enacast-pagination-info">
        <?php printf(
            esc_html__( 'Page %1$d of %2$d', 'enacast' ),
            $current_page,
            $total_pages
        ); ?>
    </span>

    <?php if ( $current_page < $total_pages ) : ?>
        <a href="<?php echo esc_url( add_query_arg( 'enacast_page', $current_page + 1 ) ); ?>"
           class="enacast-pagination-link enacast-pagination-next"
           data-page="<?php echo esc_attr( $current_page + 1 ); ?>">
            <?php esc_html_e( 'Next', 'enacast' ); ?> &raquo;
        </a>
    <?php endif; ?>
</nav>
<?php endif; ?>
