<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="enacast-podcast-single">
    <?php if ( ! empty( $podcast['program_name'] ) ) : ?>
        <nav class="enacast-breadcrumb">
            <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'program', 'program', $podcast['program_codename'] ) ); ?>">
                <?php echo esc_html( $podcast['program_name'] ); ?>
            </a>
            <span class="enacast-breadcrumb-sep">&rsaquo;</span>
            <span class="enacast-breadcrumb-current"><?php echo esc_html( $podcast['name'] ); ?></span>
        </nav>
    <?php endif; ?>

    <div class="enacast-podcast-header">
        <?php
        $logo = '';
        if ( ! empty( $podcast['logo_url'] ) ) {
            $logo = $podcast['logo_url'];
        } elseif ( ! empty( $podcast['program_logo_400x400'] ) ) {
            $logo = $podcast['program_logo_400x400'];
        }
        if ( $logo ) : ?>
            <img class="enacast-podcast-logo" src="<?php echo esc_url( $logo ); ?>"
                 alt="<?php echo esc_attr( $podcast['name'] ); ?>" />
        <?php endif; ?>

        <div class="enacast-podcast-info">
            <h2 class="enacast-podcast-title"><?php echo esc_html( $podcast['name'] ); ?></h2>

            <?php if ( ! empty( $podcast['program_name'] ) ) : ?>
                <p class="enacast-podcast-program">
                    <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'program', 'program', $podcast['program_codename'] ) ); ?>">
                        <?php echo esc_html( $podcast['program_name'] ); ?>
                    </a>
                </p>
            <?php endif; ?>

            <?php if ( ! empty( $podcast['datetime_tz'] ) ) : ?>
                <time class="enacast-podcast-date" datetime="<?php echo esc_attr( $podcast['datetime_tz'] ); ?>">
                    <?php echo esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $podcast['datetime_tz'] ) ) ); ?>
                </time>
            <?php endif; ?>

            <?php
            $duration = isset( $podcast['duration_in_seconds_cutted'] ) ? $podcast['duration_in_seconds_cutted'] : 0;
            if ( $duration > 0 ) :
                $minutes = floor( $duration / 60 );
                $seconds = $duration % 60;
            ?>
                <span class="enacast-podcast-duration">
                    <?php printf( '%d:%02d min', $minutes, $seconds ); ?>
                </span>
            <?php endif; ?>
        </div>
    </div>

    <?php if ( ! empty( $podcast['audio'] ) ) : ?>
        <?php echo Enacast_Template::render( 'podcast-player', array( 'podcast' => $podcast ) ); ?>
    <?php endif; ?>

    <?php if ( ! empty( $podcast['summary'] ) ) : ?>
        <div class="enacast-podcast-summary">
            <?php echo wp_kses_post( $podcast['summary'] ); ?>
        </div>
    <?php endif; ?>

    <?php if ( ! empty( $podcast['markers'] ) ) : ?>
        <div class="enacast-podcast-markers">
            <h3><?php esc_html_e( 'Segments', 'enacast' ); ?></h3>
            <ul class="enacast-markers-list">
                <?php foreach ( $podcast['markers'] as $marker ) :
                    $start = isset( $marker['startsecond'] ) ? (int) $marker['startsecond'] : 0;
                    $m = floor( $start / 60 );
                    $s = $start % 60;
                ?>
                    <li class="enacast-marker" data-start="<?php echo esc_attr( $start ); ?>">
                        <button type="button" class="enacast-marker-time" data-seek="<?php echo esc_attr( $start ); ?>">
                            <?php printf( '%d:%02d', $m, $s ); ?>
                        </button>
                        <span class="enacast-marker-name"><?php echo esc_html( $marker['name'] ); ?></span>
                        <?php if ( ! empty( $marker['descr'] ) ) : ?>
                            <span class="enacast-marker-desc"><?php echo esc_html( $marker['descr'] ); ?></span>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>
</div>
