<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="enacast-grid enacast-podcasts-grid">
    <?php foreach ( $podcasts as $podcast ) :
        $duration = isset( $podcast['duration_in_seconds_cutted'] ) ? $podcast['duration_in_seconds_cutted'] : 0;
        $minutes  = floor( $duration / 60 );
        $seconds  = $duration % 60;
    ?>
        <div class="enacast-card enacast-podcast-card">
            <?php
            $thumb = '';
            if ( ! empty( $podcast['logo_url'] ) ) {
                $thumb = $podcast['logo_url'];
            } elseif ( ! empty( $podcast['program_logo_400x400'] ) ) {
                $thumb = $podcast['program_logo_400x400'];
            }
            if ( $thumb ) : ?>
                <div class="enacast-card-image">
                    <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'podcast', 'podcast_id', $podcast['id'] ) ); ?>">
                        <img src="<?php echo esc_url( $thumb ); ?>"
                             alt="<?php echo esc_attr( $podcast['name'] ); ?>"
                             loading="lazy" />
                    </a>
                </div>
            <?php endif; ?>

            <div class="enacast-card-body">
                <h3 class="enacast-card-title">
                    <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'podcast', 'podcast_id', $podcast['id'] ) ); ?>">
                        <?php echo esc_html( $podcast['name'] ); ?>
                    </a>
                </h3>

                <?php if ( ! empty( $podcast['program_name'] ) ) : ?>
                    <p class="enacast-card-meta enacast-podcast-program">
                        <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'program', 'program', $podcast['program_codename'] ) ); ?>">
                            <?php echo esc_html( $podcast['program_name'] ); ?>
                        </a>
                    </p>
                <?php endif; ?>

                <?php if ( ! empty( $podcast['datetime_tz'] ) ) : ?>
                    <time class="enacast-card-meta enacast-podcast-date" datetime="<?php echo esc_attr( $podcast['datetime_tz'] ); ?>">
                        <?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $podcast['datetime_tz'] ) ) ); ?>
                    </time>
                <?php endif; ?>

                <?php if ( $duration > 0 ) : ?>
                    <span class="enacast-card-meta enacast-podcast-duration">
                        <?php printf( '%d:%02d min', $minutes, $seconds ); ?>
                    </span>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>
