<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="enacast-program-single">
    <?php if ( ! empty( $program['cover_big_landscape'] ) ) : ?>
        <div class="enacast-program-cover">
            <img src="<?php echo esc_url( $program['cover_big_landscape'] ); ?>"
                 alt="<?php echo esc_attr( $program['name'] ); ?>" />
        </div>
    <?php endif; ?>

    <div class="enacast-program-header">
        <?php if ( ! empty( $program['logo_square_400'] ) ) : ?>
            <img class="enacast-program-logo" src="<?php echo esc_url( $program['logo_square_400'] ); ?>"
                 alt="<?php echo esc_attr( $program['name'] ); ?>" />
        <?php endif; ?>

        <div class="enacast-program-info">
            <h2 class="enacast-program-title"><?php echo esc_html( $program['name'] ); ?></h2>

            <?php if ( ! empty( $program['onair'] ) ) : ?>
                <span class="enacast-badge enacast-badge-onair"><?php esc_html_e( 'On air', 'enacast' ); ?></span>
            <?php endif; ?>

            <?php if ( ! empty( $program['host'] ) ) : ?>
                <p class="enacast-program-host"><?php echo esc_html( $program['host'] ); ?></p>
            <?php endif; ?>

            <?php if ( isset( $program['podcast_count'] ) ) : ?>
                <p class="enacast-program-meta">
                    <?php printf(
                        esc_html( _n( '%d episode', '%d episodes', $program['podcast_count'], 'enacast' ) ),
                        $program['podcast_count']
                    ); ?>
                </p>
            <?php endif; ?>
        </div>
    </div>

    <?php if ( ! empty( $program['descripcio'] ) ) : ?>
        <div class="enacast-program-description">
            <?php echo wp_kses_post( wpautop( $program['descripcio'] ) ); ?>
        </div>
    <?php endif; ?>

    <?php if ( ! empty( $program['schedules'] ) ) : ?>
        <div class="enacast-program-schedule">
            <h3><?php esc_html_e( 'Schedule', 'enacast' ); ?></h3>
            <ul>
                <?php
                $days = array(
                    1 => __( 'Monday', 'enacast' ),
                    2 => __( 'Tuesday', 'enacast' ),
                    3 => __( 'Wednesday', 'enacast' ),
                    4 => __( 'Thursday', 'enacast' ),
                    5 => __( 'Friday', 'enacast' ),
                    6 => __( 'Saturday', 'enacast' ),
                    7 => __( 'Sunday', 'enacast' ),
                );
                foreach ( $program['schedules'] as $schedule ) :
                    $dow = isset( $schedule['broadcast_dow'] ) ? $schedule['broadcast_dow'] : 0;
                    $day_name = isset( $days[ $dow ] ) ? $days[ $dow ] : '';
                    $time = isset( $schedule['start_time_local'] ) ? substr( $schedule['start_time_local'], 0, 5 ) : '';
                    $end_time = '';
                    if ( $time && ! empty( $schedule['duration_in_seconds'] ) ) {
                        $start_ts = strtotime( '1970-01-01 ' . $schedule['start_time_local'] );
                        $end_ts   = $start_ts + (int) $schedule['duration_in_seconds'];
                        $end_time = date( 'H:i', $end_ts );
                    }
                ?>
                    <li>
                        <?php
                        $time_str = $day_name . ' ' . $time;
                        if ( $end_time ) {
                            $time_str .= '–' . $end_time;
                        }
                        echo esc_html( $time_str );
                        ?>
                        <?php if ( ! empty( $schedule['is_repetition'] ) ) : ?>
                            <span class="enacast-badge enacast-badge-repeat"><?php esc_html_e( 'Repeat', 'enacast' ); ?></span>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <?php if ( ! empty( $rss_url ) && ! empty( $subscribe ) ) : ?>
        <div class="enacast-subscribe">
            <h3><?php esc_html_e( 'Subscribe', 'enacast' ); ?></h3>
            <div class="enacast-subscribe-buttons">
                <?php if ( in_array( 'rss', $subscribe, true ) ) : ?>
                    <a href="<?php echo esc_url( $rss_url ); ?>" class="enacast-subscribe-btn enacast-subscribe-rss" target="_blank" rel="noopener" title="RSS">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><circle cx="6.18" cy="17.82" r="2.18"/><path d="M4 4.44v2.83c7.03 0 12.73 5.7 12.73 12.73h2.83c0-8.59-6.97-15.56-15.56-15.56zm0 5.66v2.83c3.9 0 7.07 3.17 7.07 7.07h2.83c0-5.47-4.43-9.9-9.9-9.9z"/></svg>
                        RSS
                    </a>
                <?php endif; ?>
                <?php if ( in_array( 'apple', $subscribe, true ) ) : ?>
                    <a href="podcast://<?php echo esc_attr( preg_replace( '#^https?://#', '', $rss_url ) ); ?>" class="enacast-subscribe-btn enacast-subscribe-apple" title="Apple Podcasts">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M12 1C5.95 1 1 5.95 1 12c0 3.11 1.31 5.92 3.4 7.92C4.15 18.65 4 17.36 4 16c0-4.42 3.58-8 8-8s8 3.58 8 8c0 1.36-.15 2.65-.4 3.92A10.95 10.95 0 0023 12C23 5.95 18.05 1 12 1zm0 7a5 5 0 00-5 5c0 .89.23 1.72.64 2.44C7.24 14.3 7 13.18 7 12a5 5 0 0110 0c0 1.18-.24 2.3-.64 3.44.41-.72.64-1.55.64-2.44a5 5 0 00-5-5zm0 4a2.5 2.5 0 00-2.5 2.5c0 .51.15.98.41 1.37A2.5 2.5 0 0112 14.5a2.5 2.5 0 012.09 1.37c.26-.39.41-.86.41-1.37A2.5 2.5 0 0012 12zm-1.5 6.5c-.2.97-.5 2.5-.5 3.5 0 .55.45 1 1 1h2c.55 0 1-.45 1-1 0-1-.3-2.53-.5-3.5-.15-.71-.73-1.25-1.5-1.25s-1.35.54-1.5 1.25z"/></svg>
                        Apple Podcasts
                    </a>
                <?php endif; ?>
                <?php if ( in_array( 'overcast', $subscribe, true ) ) : ?>
                    <a href="overcast://x-callback-url/add?url=<?php echo esc_attr( urlencode( $rss_url ) ); ?>" class="enacast-subscribe-btn enacast-subscribe-overcast" title="Overcast">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M12 1C5.95 1 1 5.95 1 12s4.95 11 11 11 11-4.95 11-11S18.05 1 12 1zm0 19.5c-4.69 0-8.5-3.81-8.5-8.5S7.31 3.5 12 3.5s8.5 3.81 8.5 8.5-3.81 8.5-8.5 8.5zm0-15A6.5 6.5 0 005.5 12c0 3.59 2.91 6.5 6.5 6.5s6.5-2.91 6.5-6.5S15.59 5.5 12 5.5zm0 11.25l-2-3.75h4l-2 3.75z"/></svg>
                        Overcast
                    </a>
                <?php endif; ?>
                <?php if ( in_array( 'pocketcasts', $subscribe, true ) ) : ?>
                    <a href="pktc://subscribe/<?php echo esc_attr( $rss_url ); ?>" class="enacast-subscribe-btn enacast-subscribe-pocketcasts" title="Pocket Casts">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M12 1C5.95 1 1 5.95 1 12s4.95 11 11 11 11-4.95 11-11S18.05 1 12 1zm0 3a8 8 0 018 8h-2.5a5.5 5.5 0 00-5.5-5.5V4zm0 3a5 5 0 015 5h-2.5A2.5 2.5 0 0012 9.5V7zm0 3a2 2 0 012 2 2 2 0 01-2 2 2 2 0 01-2-2 2 2 0 012-2z"/></svg>
                        Pocket Casts
                    </a>
                <?php endif; ?>
                <?php if ( in_array( 'castro', $subscribe, true ) ) : ?>
                    <a href="castros://subscribe/<?php echo esc_attr( $rss_url ); ?>" class="enacast-subscribe-btn enacast-subscribe-castro" title="Castro">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c3.87 0 7 3.13 7 7s-3.13 7-7 7-7-3.13-7-7 3.13-7 7-7zm0 3a4 4 0 00-4 4 4 4 0 004 4 4 4 0 004-4 4 4 0 00-4-4zm0 2a2 2 0 012 2 2 2 0 01-2 2 2 2 0 01-2-2 2 2 0 012-2z"/></svg>
                        Castro
                    </a>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>

    <?php if ( ! empty( $podcasts ) ) : ?>
        <div class="enacast-program-episodes">
            <h3><?php esc_html_e( 'Recent episodes', 'enacast' ); ?></h3>
            <?php echo Enacast_Template::render( 'podcasts-list', array( 'podcasts' => $podcasts ) ); ?>
            <?php if ( ! empty( $podcasts_url ) && ! empty( $program['codename'] ) ) : ?>
                <p class="enacast-see-all">
                    <a href="<?php echo esc_url( add_query_arg( 'program', $program['codename'], $podcasts_url ) ); ?>">
                        <?php esc_html_e( 'See all episodes', 'enacast' ); ?> &rarr;
                    </a>
                </p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>
