<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="enacast-grid enacast-programs-grid">
    <?php foreach ( $programs as $program ) : ?>
        <div class="enacast-card enacast-program-card">
            <?php if ( ! empty( $program['logo_square_400'] ) ) : ?>
                <div class="enacast-card-image">
                    <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'program', 'program', $program['codename'] ) ); ?>">
                        <img src="<?php echo esc_url( $program['logo_square_400'] ); ?>"
                             alt="<?php echo esc_attr( $program['name'] ); ?>"
                             loading="lazy" />
                    </a>
                </div>
            <?php else : ?>
                <div class="enacast-card-image">
                    <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'program', 'program', $program['codename'] ) ); ?>">
                        <div class="enacast-card-placeholder">
                            <span><?php echo esc_html( mb_strtoupper( mb_substr( $program['name'], 0, 1 ) ) ); ?></span>
                        </div>
                    </a>
                </div>
            <?php endif; ?>

            <?php if ( ! empty( $program['onair'] ) || ! empty( $program['featured'] ) ) : ?>
                <div class="enacast-card-badges">
                    <?php if ( ! empty( $program['onair'] ) ) : ?>
                        <span class="enacast-badge enacast-badge-onair"><?php esc_html_e( 'On air', 'enacast' ); ?></span>
                    <?php endif; ?>
                    <?php if ( ! empty( $program['featured'] ) ) : ?>
                        <span class="enacast-badge enacast-badge-featured"><?php esc_html_e( 'Featured', 'enacast' ); ?></span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <div class="enacast-card-body">
                <h3 class="enacast-card-title">
                    <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'program', 'program', $program['codename'] ) ); ?>">
                        <?php echo esc_html( $program['name'] ); ?>
                    </a>
                </h3>

                <?php if ( ! empty( $program['descripcio'] ) ) : ?>
                    <p class="enacast-card-description">
                        <?php echo esc_html( wp_trim_words( $program['descripcio'], 30 ) ); ?>
                    </p>
                <?php endif; ?>

                <?php if ( ! empty( $program['host'] ) ) : ?>
                    <p class="enacast-card-meta">
                        <?php echo esc_html( $program['host'] ); ?>
                    </p>
                <?php endif; ?>

                <?php if ( isset( $program['podcast_count'] ) && $program['podcast_count'] > 0 ) : ?>
                    <p class="enacast-card-meta">
                        <?php printf(
                            esc_html( _n( '%d episode', '%d episodes', $program['podcast_count'], 'enacast' ) ),
                            $program['podcast_count']
                        ); ?>
                    </p>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>
