<?php if ( ! defined( 'ABSPATH' ) ) exit;

$day_names_short = array(
    1 => __( 'Mon', 'enacast' ),
    2 => __( 'Tue', 'enacast' ),
    3 => __( 'Wed', 'enacast' ),
    4 => __( 'Thu', 'enacast' ),
    5 => __( 'Fri', 'enacast' ),
    6 => __( 'Sat', 'enacast' ),
    7 => __( 'Sun', 'enacast' ),
);

$day_names_full = array(
    1 => __( 'Monday', 'enacast' ),
    2 => __( 'Tuesday', 'enacast' ),
    3 => __( 'Wednesday', 'enacast' ),
    4 => __( 'Thursday', 'enacast' ),
    5 => __( 'Friday', 'enacast' ),
    6 => __( 'Saturday', 'enacast' ),
    7 => __( 'Sunday', 'enacast' ),
);
?>
<div class="enacast-schedule alignwide">
    <div class="enacast-schedule-nav">
        <a href="<?php echo esc_url( add_query_arg( array( 'enacast_year' => $prev_year, 'enacast_week' => $prev_week ) ) ); ?>" class="enacast-schedule-prev">
            &laquo; <?php esc_html_e( 'Previous week', 'enacast' ); ?>
        </a>
        <div class="enacast-schedule-current">
            <span class="enacast-schedule-daterange">
                <?php echo esc_html( $week_start . ' – ' . $week_end ); ?>
            </span>
            <span class="enacast-schedule-weeknum">
                <?php printf( esc_html__( 'Week %d', 'enacast' ), $week ); ?>
            </span>
        </div>
        <a href="<?php echo esc_url( add_query_arg( array( 'enacast_year' => $next_year, 'enacast_week' => $next_week ) ) ); ?>" class="enacast-schedule-next">
            <?php esc_html_e( 'Next week', 'enacast' ); ?> &raquo;
        </a>
    </div>

    <div class="enacast-schedule-grid">
        <?php
        // Index schedule by dow
        $by_dow = array();
        if ( is_array( $schedule ) ) {
            foreach ( $schedule as $day ) {
                $dow = isset( $day['dow'] ) ? (int) $day['dow'] : 0;
                $by_dow[ $dow ] = isset( $day['schedules'] ) ? $day['schedules'] : array();
            }
        }
        ?>

        <?php for ( $dow = 1; $dow <= 7; $dow++ ) :
            $entries = isset( $by_dow[ $dow ] ) ? $by_dow[ $dow ] : array();
            // Sort by start time
            usort( $entries, function( $a, $b ) {
                return strcmp( $a['start_time_local'], $b['start_time_local'] );
            });
            $day_date = isset( $day_dates[ $dow ] ) ? $day_dates[ $dow ] : '';
        ?>
            <div class="enacast-schedule-day">
                <h4 class="enacast-schedule-day-name">
                    <span class="enacast-schedule-day-abbr"><?php echo esc_html( $day_names_short[ $dow ] ); ?></span>
                    <span class="enacast-schedule-day-full"><?php echo esc_html( $day_names_full[ $dow ] ); ?></span>
                    <?php if ( $day_date ) : ?>
                        <span class="enacast-schedule-day-date"><?php echo esc_html( $day_date ); ?></span>
                    <?php endif; ?>
                </h4>

                <?php if ( empty( $entries ) ) : ?>
                    <p class="enacast-schedule-empty"><?php esc_html_e( 'No programs', 'enacast' ); ?></p>
                <?php else : ?>
                    <ul class="enacast-schedule-entries">
                        <?php foreach ( $entries as $entry ) : ?>
                            <li class="enacast-schedule-entry <?php echo ! empty( $entry['is_repetition'] ) ? 'enacast-schedule-repeat' : ''; ?>">
                                <?php if ( ! empty( $entry['program_logo_square_300'] ) ) : ?>
                                    <img class="enacast-schedule-logo"
                                         src="<?php echo esc_url( $entry['program_logo_square_300'] ); ?>"
                                         alt="<?php echo esc_attr( $entry['program_title'] ); ?>"
                                         loading="lazy" />
                                <?php endif; ?>

                                <div class="enacast-schedule-entry-info">
                                    <span class="enacast-schedule-time">
                                        <?php
                                        $start = esc_html( substr( $entry['start_time_local'], 0, 5 ) );
                                        if ( ! empty( $entry['end_time_local'] ) ) {
                                            echo $start . '–' . esc_html( substr( $entry['end_time_local'], 0, 5 ) );
                                        } else {
                                            echo $start;
                                        }
                                        ?>
                                    </span>
                                    <span class="enacast-schedule-program">
                                        <a href="<?php echo esc_url( Enacast_Settings::get_detail_url( 'program', 'program', $entry['program_codename'] ) ); ?>">
                                            <?php echo esc_html( $entry['program_title'] ); ?>
                                        </a>
                                    </span>
                                    <?php if ( ! empty( $entry['is_repetition'] ) ) : ?>
                                        <span class="enacast-badge enacast-badge-repeat"><?php esc_html_e( 'Repeat', 'enacast' ); ?></span>
                                    <?php endif; ?>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>
        <?php endfor; ?>
    </div>
</div>
